/*
 * AltaLlogater.java
 *
 * Created on 29 de mayo de 2008, 15:35
 */

package actions;

import entitats.Llogater;
import entitats.Propietari;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
import org.apache.tools.ant.taskdefs.condition.IsSet;
/**
 *
 * @author dai
 * @version
 */

public class AltaLlogater extends Action {
    
    DataSource ds = null;
    Connection con = null;
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
            Llogater llogater = (Llogater) form;
        String tipus;
        try {
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            
            //Si estan els camps nom o cognom i raosocial plens, fa un find forward informant que nomes
            //un camp d'ells pot estar ple per diferenciar si es persona o empresa
            if ((!llogater.getNom().isEmpty() || !llogater.getCognom1().isEmpty() || !llogater.getCognom2().isEmpty()) && !llogater.getRaoSocial().isEmpty() ) {
                llogater.setError("Nomes s'accepta nom i cognoms o b rao social");
                return mapping.findForward("ok");
            }
            
            else {
                
                //Comprova si es un usuari o persona el client q s'introduira
                if (llogater.getRaoSocial().isEmpty()) {
                    tipus = "persona";
                    llogater.setTipus("persona");
                } else {
                    tipus = "empresa";
                    llogater.setTipus("empresa");
                }
                
                //Comprova que les dades obligatories del formulari estan plenes
                if (llogater.comprovaDadesFormulari()) {
                    return mapping.findForward("ok");
                } else {
                    
                    //Fa l'insert a la taula d'entitats
                    st.executeUpdate("INSERT INTO entitats (nif, tipus) VALUES ('"+llogater.getNif()+"', '"+llogater.getTipus()+"')");
                    ResultSet rs1 = st.executeQuery("SELECT last_insert_id()");
                    rs1.next();
                    int idEntitat = rs1.getInt(1);
                    rs1.close();
                    
                    //Inserta la relacio a la taula clients i propietaris
                    st.executeUpdate("INSERT INTO clients (id_entitat) VALUES ("+idEntitat+")");
                    rs1 = st.executeQuery("SELECT last_insert_id()");
                    rs1.next();
                    int idClient = rs1.getInt(1);
                    rs1.close();

                    st.executeUpdate("INSERT INTO cerques (superficie_minima, preu, caracteristiques) VALUES ("+llogater.getSuperficieMinima()+", "+llogater.getPreu()+", "+llogater.getCaracteristiques()+")");
                    rs1 = st.executeQuery("SELECT last_insert_id()");
                    rs1.next();
                    int idCerca = rs1.getInt(1);
                    rs1.close();
                    
                    System.out.println("INSERT INTO llogaters (id_client, id_preferencies, actiu) VALUES ("+idClient+", "+idCerca+", 1)");
                    st.executeUpdate("INSERT INTO llogaters (id_client, id_preferencies, actiu) VALUES ("+idClient+", "+idCerca+", 1)");
                    
                    //Comprova si es persona o empresa i l'introdueix a la taula corresponent
                    if (tipus.equals("persona")) {
                        st.executeUpdate("INSERT INTO persones (id_entitat, nom, cognom1, cognom2) VALUES ("+idEntitat+", '"+llogater.getNom()+"', '"+llogater.getCognom1()+"', '"+llogater.getCognom2()+"')");
                    } else if (tipus.equals("empresa")){
                        st.executeUpdate("INSERT INTO empreses (id_entitat, rao_social) VALUES ("+idEntitat+", '"+llogater.getRaoSocial()+"')");
                        
                    }
                    
                    //Si el telefon no esta buit el fica a la bd
                    if (!llogater.getTelefon().isEmpty()) {
                        st.executeUpdate("INSERT INTO telefons (telefon) VALUES ('"+llogater.getTelefon()+"')");
                        rs1 = st.executeQuery("SELECT last_insert_id()");
                        rs1.next();
                        int idTelefon = rs1.getInt(1);
                        st.executeUpdate("INSERT INTO telefon_entitat (id_telefon, id_entitat) VALUES ("+idEntitat+", "+idTelefon+")");
                    }
                    
                    //Si l'adresa no esta buida la inserta a la bd
                    if (!llogater.getAdresa().isEmpty()){
                        st.executeUpdate("INSERT INTO adreses (id_zona, adresa) VALUES ("+llogater.getZona()+", '"+llogater.getAdresa()+"')");
                        
                        rs1 = st.executeQuery("SELECT last_insert_id()");
                        rs1.next();
                        int idAdresa = rs1.getInt(1);
                        st.executeUpdate("INSERT INTO adresa_entitat (id_adresa, id_entitat) VALUES ("+idAdresa+", "+idEntitat+")");
                    }
                    st.close();
                    llogater.setError("S'ha insertat correctament");
                }
            }
        }catch(Exception excepcio){
            llogater.setError("<font color='red'>Excepcio ocorreguda en acions.AltaLlogater<br>" +
                    "\n"+excepcio.getMessage()+"</font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                llogater.setError("<font color='red'>Excepcio ocorreguda en acions.AltaLlogater<br>"+
                        "\n"+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}
